/*
 * Decompiled with CFR 0.152.
 */
package DE.siemens.ad.logo.model;

import CH.ifa.draw.util.Storable;
import CH.ifa.draw.util.StorableInput;
import CH.ifa.draw.util.StorableOutput;
import DE.siemens.ad.logo.model.EqualsCheck;
import DE.siemens.ad.logo.util.DifferenceTableModel;
import DE.siemens.ad.logo.util.Language;
import DE.siemens.ad.logo.util.Util;
import java.io.IOException;
import java.io.Serializable;
import java.util.Vector;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class EthernetConnection
implements Serializable,
Storable {
    private static final long serialVersionUID = 3273146517173250146L;
    private Vector<Transfer> fVMReadTransactions;
    private Vector<Transfer> fVMWriteTransactions;
    private boolean fClient;
    private String fRemoteIP;
    private int fStationID;
    private String fAcceptedIP;
    private String fLocalTsap;
    private String fRemoteTsap;
    private int fAliveInterval;
    private int fID;
    private static final transient int DATA_TYPE_BYTE = 2;

    public EthernetConnection() {
        this.fVMWriteTransactions = new Vector();
        this.fVMReadTransactions = new Vector();
    }

    public EthernetConnection(int id) {
        this.fID = id;
        this.fVMWriteTransactions = new Vector();
        this.fVMReadTransactions = new Vector();
    }

    public int getID() {
        return this.fID;
    }

    public void setID(int fid) {
        this.fID = fid;
    }

    public void addVMTransaction(Transfer transfer) {
        if (transfer.fOperateCode == 0) {
            this.fVMReadTransactions.add(transfer);
        } else {
            this.fVMWriteTransactions.add(transfer);
        }
    }

    public void clearVMTransaction() {
        this.fVMWriteTransactions.clear();
        this.fVMReadTransactions.clear();
    }

    public Vector<Transfer> getVMWriteTransactions() {
        return this.fVMWriteTransactions;
    }

    public Vector<Transfer> getVMReadTransactions() {
        return this.fVMReadTransactions;
    }

    public String getRemoteIP() {
        return this.fRemoteIP;
    }

    public void setRemoteIP(String remoteIP) {
        this.fRemoteIP = remoteIP;
    }

    public boolean isClient() {
        return this.fClient;
    }

    public void setClient(boolean client) {
        this.fClient = client;
    }

    public String getLocalTsap() {
        return this.fLocalTsap;
    }

    public void setLocalTsap(String localTsap) {
        this.fLocalTsap = localTsap;
    }

    public String getRemoteTsap() {
        return this.fRemoteTsap;
    }

    public void setRemoteTsap(String remoteTsap) {
        this.fRemoteTsap = remoteTsap;
    }

    public int getAliveInterval() {
        return this.fAliveInterval;
    }

    public void setAliveInterval(int aliveInterval) {
        this.fAliveInterval = aliveInterval;
    }

    public String getAcceptedIP() {
        return this.fAcceptedIP;
    }

    public void setAcceptedIP(String acceptedIP) {
        this.fAcceptedIP = acceptedIP;
    }

    public boolean isNotCreateByUser() {
        return this.fClient && ("19.FF".equals(this.fLocalTsap) || "19.00".equals(this.fLocalTsap));
    }

    public boolean isForSlave() {
        return this.getLocalTsap().equals("19.FF");
    }

    public String toString() {
        String ret = this.isNotCreateByUser() ? (this.isForSlave() ? Language.getString("dialog.options.color.connection") + this.fID + "( " + Language.getString("panel.networkNodePanel.slaveSelection") + this.fRemoteIP + ")" : "") : (this.getRemoteTsap() != null ? (this.isClient() ? String.valueOf(Language.getString("dialog.options.color.connection") + this.fID + "(" + Language.getString("ethernet.connectionConfigurePanel.clientOf", "Client: To") + this.fRemoteIP + ")") : String.valueOf(Language.getString("dialog.options.color.connection") + this.fID + "(" + Language.getString("ethernet.connectionConfigurePanel.server", "Server") + ")")) : String.valueOf(Language.getString("dialog.options.color.connection") + this.fID));
        return ret;
    }

    public int getStationID() {
        return this.fStationID;
    }

    public void setStationID(int fStationID) {
        this.fStationID = fStationID;
    }

    public boolean compareTo(EthernetConnection other, DifferenceTableModel differences) {
        boolean diff = true;
        String ethernetStr = Language.getString("extra.ethernet.connections", "Ethernet Connections");
        String connStr = Language.getString("dialog.options.color.connection", "Connection");
        String clientStr = Language.getString("ethernet.connectionConfigurePanel.client", "Client");
        String severStr = Language.getString("ethernet.connectionConfigurePanel.server", "Sever");
        String slaveStr = Language.getString("panel.networkNodePanel.slaveSelection", "Slave");
        if (this.getID() != other.getID()) {
            diff = false;
            differences.add(ethernetStr + connStr + " ID", String.valueOf(this.getID()), String.valueOf(other.getID()));
        } else {
            if (this.isForSlave() && other.isForSlave()) {
                return true;
            }
            if (this.isClient() != other.isClient() && !this.isForSlave() && !other.isForSlave()) {
                diff = false;
                differences.add(ethernetStr + " - " + connStr + this.getID(), this.isClient() ? clientStr : severStr, other.isClient() ? clientStr : severStr);
            } else if (this.isForSlave() && !other.isForSlave()) {
                diff = false;
                differences.add(ethernetStr + " - " + connStr + this.getID(), slaveStr, other.isClient() ? clientStr : severStr);
            } else if (!this.isForSlave() && other.isForSlave()) {
                diff = false;
                differences.add(ethernetStr + " - " + connStr + this.getID(), this.isClient() ? clientStr : severStr, slaveStr);
            } else {
                String remotePropertiesStr;
                StringBuffer diffStr1 = new StringBuffer("");
                StringBuffer diffStr2 = new StringBuffer("");
                StringBuffer diffStr3 = new StringBuffer("");
                String tabStr = "    ";
                boolean propdiff = true;
                if (!Util.isObjectEqual(this.getLocalTsap(), other.getLocalTsap())) {
                    String localPropertiesStr = Language.getString("ethernet.connectionConfigurePanel.localProperties", "Local Properties");
                    diff = false;
                    propdiff = false;
                    diffStr1.append(ethernetStr + " - " + connStr + this.getID() + "\n");
                    diffStr1.append(tabStr);
                    diffStr1.append(localPropertiesStr + " - " + "TSAP");
                    diffStr2.append("\n" + this.getLocalTsap());
                    diffStr3.append("\n" + other.getLocalTsap());
                }
                if (!Util.isObjectEqual(this.getRemoteTsap(), other.getRemoteTsap())) {
                    remotePropertiesStr = Language.getString("ethernet.connectionConfigurePanel.remoteProperties", "Remote Properties");
                    if (propdiff) {
                        diffStr1.append(ethernetStr + " - " + connStr + this.getID() + "\n");
                    } else {
                        diffStr1.append("\n");
                    }
                    diffStr1.append(tabStr);
                    diffStr1.append(remotePropertiesStr + " - " + "TSAP");
                    diffStr2.append("\n");
                    diffStr2.append(this.getRemoteTsap());
                    diffStr3.append("\n");
                    diffStr3.append(other.getRemoteTsap());
                    diff = false;
                    propdiff = false;
                }
                if (this.isClient() && other.isClient() && !Util.isObjectEqual(this.getRemoteIP(), other.getRemoteIP())) {
                    remotePropertiesStr = Language.getString("ethernet.connectionConfigurePanel.remoteProperties", "Remote Properties");
                    String ipaddressStr = Language.getString("ethernet.tcpSettingPanel.columnIPAddress", "IP Address");
                    if (propdiff) {
                        diffStr1.append(ethernetStr + " - " + connStr + this.getID() + "\n");
                    } else {
                        diffStr1.append("\n");
                    }
                    diffStr1.append(tabStr);
                    diffStr1.append(remotePropertiesStr + " - " + ipaddressStr);
                    diffStr2.append("\n");
                    diffStr2.append(this.getRemoteIP());
                    diffStr3.append("\n");
                    diffStr3.append(other.getRemoteIP());
                    diff = false;
                    propdiff = false;
                }
                if (this.getAliveInterval() != other.getAliveInterval()) {
                    String aliveStr = Language.getString("ethernet.connectionConfigurePanel.aliveInterval");
                    if (propdiff) {
                        diffStr1.append(ethernetStr + " - " + connStr + this.getID() + "\n");
                    } else {
                        diffStr1.append("\n");
                    }
                    diffStr1.append(tabStr);
                    diffStr1.append(aliveStr);
                    diffStr2.append("\n");
                    diffStr2.append(String.valueOf(this.getAliveInterval()));
                    diffStr3.append("\n");
                    diffStr3.append(String.valueOf(other.getAliveInterval()));
                    diff = false;
                    propdiff = false;
                }
                if (!propdiff) {
                    differences.add(diffStr1.toString(), diffStr2.toString(), diffStr3.toString());
                }
                if (this.isClient() && other.isClient() && !this.compareTransfer(this.getVMReadTransactions(), other.getVMReadTransactions(), this.getVMWriteTransactions(), other.getVMWriteTransactions(), differences)) {
                    diff = false;
                }
                if (!(this.isClient() || other.isClient() || Util.isObjectEqual(this.fAcceptedIP, other.getAcceptedIP()))) {
                    diff = false;
                    String accpStr = Language.getString("compare.acceptconncetion");
                    String allStr = Language.getString("ethernet.connectionConfigurePanel.acceptAllRequests");
                    differences.add(ethernetStr + connStr + this.getID() + " - " + accpStr, "\n" + (Util.isEmptyString(this.getAcceptedIP()) ? allStr : this.getAcceptedIP()), "\n" + (Util.isEmptyString(other.getAcceptedIP()) ? allStr : other.getAcceptedIP()));
                }
            }
        }
        return diff;
    }

    private boolean compareTransfer(Vector<Transfer> readTransfer, Vector<Transfer> otherReadTransfer, Vector<Transfer> writeTransfer, Vector<Transfer> otherWriteTransfer, DifferenceTableModel differences) {
        Vector<Transfer> t1 = new Vector<Transfer>(readTransfer);
        t1.addAll(writeTransfer);
        Vector<Transfer> t2 = new Vector<Transfer>(otherReadTransfer);
        t2.addAll(otherWriteTransfer);
        String ethernetStr = Language.getString("extra.ethernet.connections", "Ethernet Connections");
        String connStr = Language.getString("dialog.options.color.connection", "Connection");
        String transferStr = Language.getString("ethernet.connection.datatransfer", "Data Transfer") + " ";
        String lineStr = Language.getString("dialog.parameter.message.tickerLine", "Line") + " ";
        String tabStr = "    ";
        for (int i = 0; i < t1.size(); ++i) {
            if (i > t2.size() - 1) {
                String notFoundStr = Language.getString("compare.notFound", "Not found");
                differences.add(ethernetStr + " - " + connStr + this.getID() + ":\n" + tabStr + transferStr + lineStr + (i + 1), "", "\n" + notFoundStr);
                return false;
            }
            if (t1.get((int)i).fOperateCode == t2.get((int)i).fOperateCode && t1.get(i).isEqual(t2.get(i))) continue;
            String diffStr = Language.getString("ethernet.connection.datatransfer.different", "different");
            differences.add(ethernetStr + " - " + connStr + this.getID() + ":\n" + tabStr + transferStr + lineStr + (i + 1), "\n" + diffStr, "\n" + diffStr);
            return false;
        }
        for (int j = 0; j < t2.size(); ++j) {
            if (j <= t1.size() - 1) continue;
            String notFoundStr = Language.getString("compare.notFound", "Not found");
            differences.add(ethernetStr + " - " + connStr + this.getID() + ":\n" + tabStr + transferStr + lineStr + (j + 1), "\n" + notFoundStr, "");
            return false;
        }
        return true;
    }

    @Override
    public void read(StorableInput dr) throws IOException {
        int writeCnt;
        int readCnt = dr.readInt();
        if (readCnt > 0) {
            this.fVMReadTransactions = new Vector(readCnt);
            for (int i = 0; i < readCnt; ++i) {
                this.fVMReadTransactions.add((Transfer)dr.readStorable());
            }
        }
        if ((writeCnt = dr.readInt()) > 0) {
            this.fVMWriteTransactions = new Vector(writeCnt);
            for (int i = 0; i < writeCnt; ++i) {
                this.fVMWriteTransactions.add((Transfer)dr.readStorable());
            }
        }
        this.fClient = dr.readBoolean();
        this.fRemoteIP = dr.readString();
        this.fStationID = dr.readInt();
        this.fAcceptedIP = dr.readString();
        this.fLocalTsap = dr.readString();
        this.fRemoteTsap = dr.readString();
        this.fAliveInterval = dr.readInt();
        this.fID = dr.readInt();
    }

    @Override
    public void write(StorableOutput dw) {
        if (this.fVMReadTransactions != null) {
            dw.writeInt(this.fVMReadTransactions.size());
            for (Transfer each : this.fVMReadTransactions) {
                dw.writeStorable(each);
            }
        } else {
            dw.writeInt(0);
        }
        if (this.fVMWriteTransactions != null) {
            dw.writeInt(this.fVMWriteTransactions.size());
            for (Transfer each : this.fVMWriteTransactions) {
                dw.writeStorable(each);
            }
        } else {
            dw.writeInt(0);
        }
        dw.writeBoolean(this.fClient);
        dw.writeString(this.fRemoteIP);
        dw.writeInt(this.fStationID);
        dw.writeString(this.fAcceptedIP);
        dw.writeString(this.fLocalTsap);
        dw.writeString(this.fRemoteTsap);
        dw.writeInt(this.fAliveInterval);
        dw.writeInt(this.fID);
    }

    public static class Transfer
    implements Serializable,
    EqualsCheck,
    Storable {
        private static final long serialVersionUID = -1654322700136387136L;
        public int fOperateCode;
        public int fDataUnit;
        public int fLocalAddress;
        public int fRemoteAreaID;
        public int fRemoteAddress;
        public int fBlockAddress;
        public int fBlockByteAddress;
        public int fLength;
        public int fLocalDataBlockType;
        public int fRemoteDataBlockType;
        public static final int READ_OPERATION = 0;
        public static final int WRITE_OPERATION = 1;
        public static final int LOCAL_INPUT_START_ADDR = 0;
        public static final int LOCAL_ANALOG_INPUT_START_ADDR = 3;
        public static final int LOCAL_OUTPUT_START_ADDR = 19;
        public static final int LOCAL_ANALOG_OUTPUT_START_ADDR = 21;
        public static final int DEFAULT_AREA_ID = 0;
        public static final int OUTPUT_AREA_ID = 1;
        public static final int FLAG_AREA_ID = 2;
        public static final int ANALOG_INPUT_AREA_ID = 3;
        public static final int ANALOG_OUTPUT_AREA_ID = 4;
        public static final int ANALOG_FLAG_AREA_ID = 5;

        public Transfer() {
        }

        public Transfer(int operateCode, int localAddress, int localDataType, int remoteAddress, int remoteDataType, int length) {
            this.fLocalDataBlockType = localDataType;
            this.fRemoteDataBlockType = remoteDataType;
            this.fOperateCode = operateCode;
            this.fDataUnit = 2;
            this.fLocalAddress = localAddress;
            this.fRemoteAreaID = 0;
            this.fRemoteAddress = remoteAddress;
            this.fLength = length;
        }

        public Transfer(int operateCode, int localAddress, int localDataType, int blockAddress, int blockByteAddress, int length, boolean isDB) {
            this.fLocalDataBlockType = localDataType;
            this.fRemoteDataBlockType = 1;
            this.fOperateCode = operateCode;
            this.fDataUnit = 2;
            this.fLocalAddress = localAddress;
            this.fRemoteAreaID = 0;
            this.fBlockAddress = blockAddress;
            this.fBlockByteAddress = blockByteAddress;
            this.fLength = length;
        }

        public boolean isEqual(Object other) {
            if (!(other instanceof Transfer)) {
                return false;
            }
            Transfer transfer = (Transfer)other;
            return this.fOperateCode == transfer.fOperateCode && this.fDataUnit == transfer.fDataUnit && this.fRemoteAreaID == transfer.fRemoteAreaID && this.fLength == transfer.fLength && this.fLocalAddress == transfer.fLocalAddress && this.fRemoteAddress == transfer.fRemoteAddress && this.fBlockAddress == transfer.fBlockAddress && this.fBlockByteAddress == transfer.fBlockByteAddress && this.fLocalDataBlockType == transfer.fLocalDataBlockType && this.fRemoteDataBlockType == transfer.fRemoteDataBlockType;
        }

        public void read(StorableInput dr) throws IOException {
            this.fOperateCode = dr.readInt();
            this.fDataUnit = dr.readInt();
            this.fLocalAddress = dr.readInt();
            this.fRemoteAreaID = dr.readInt();
            this.fRemoteAddress = dr.readInt();
            this.fBlockAddress = dr.readInt();
            this.fBlockByteAddress = dr.readInt();
            this.fLength = dr.readInt();
            this.fLocalDataBlockType = dr.readInt();
            this.fRemoteDataBlockType = dr.readInt();
        }

        public void write(StorableOutput dw) {
            dw.writeInt(this.fOperateCode);
            dw.writeInt(this.fDataUnit);
            dw.writeInt(this.fLocalAddress);
            dw.writeInt(this.fRemoteAreaID);
            dw.writeInt(this.fRemoteAddress);
            dw.writeInt(this.fBlockAddress);
            dw.writeInt(this.fBlockByteAddress);
            dw.writeInt(this.fLength);
            dw.writeInt(this.fLocalDataBlockType);
            dw.writeInt(this.fRemoteDataBlockType);
        }
    }
}

